/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Rechnungsgesamtbetrag einschließlich Umsatzsteuer
 * Datentyp: udt:AmountType
 * Hinweis: Der Rechnungsgesamtbetrag einschließlich Umsatzsteuer ist der Rechnungsgesamtbetrag
 *          ohne Umsatzsteuer zuzüglich des Gesamtbetrages der Rechnungsumsatzsteuer.
 * Kardinalität: 1 … 1
 * Anwendung: Der Gesamtbetrag der Rechnung mit Umsatzsteuer
 * Geschäftsregeln: BR-14, BR-CO-15, BR-CO-16
 */
public class GrandTotalAmount extends InlineRam {
	/**
	 * neues Tag
	 * @param amount einzusetzender Betrag
	 */
	public GrandTotalAmount(long amount) {
		super("GrandTotalAmount");
		content(amount);
	}
}
