/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import static de.srsoftware.document.zugferd.tags.base.Ram.SCHEME;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:IDType
 * Kardinalität: 0 .. 1
 * Anwendung: Eine auf einem registrierten Schema basierende Artikelkennung
 */
public class GlobalID extends InlineRam {

	// TODO: es ist nicht ganz klar, wo der Wert herkommt
	/**
	 * Datentyp: xs:token
	 * Hinweis: Das Identifikationsschema muss aus den Einträgen der von der ISO/IEC 6523 Maintenance Agency veröffentlichten Liste angegeben werden.
	 * Kardinalität: required
	 * Anwendung: die Kennung für das Identifikationsschema der Kennung eines Artikels nach registriertem Schema
	 * Geschäftsregel: BR-64 / Kennung eines Artikels nach registriertem Schema
	 */
	private static final String DEFAULT_SCHEME = "0160";

	/**
	 * neues Tag
	 * @param id einzusetzende Kennung
	 */
	public GlobalID(String id) {
		super("GlobalID");
		attr(SCHEME,DEFAULT_SCHEME);
		content(id);
	}
}
