/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Fälliger Zahlungsbetrag
 * Datentyp: udt:AmountType
 * Hinweis: Dieser Betrag ist der Rechnungsgesamtbetrag einschließlich Umsatzsteuer
 *          abzüglich des im Voraus gezahlten Betrages.
 *          Im Falle einer vollständig beglichenen Rechnung ist dieser Betrag gleich null.
 *          Der Betrag kann negativ sein; in diesem Fall schuldet der Verkäufer dem Käufer den Betrag.
 * Kardinalität: 1 … 1
 * Anwendung: Der ausstehende Betrag, um dessen Zahlung gebeten wird
 * Geschäftsregeln: BR-15, BR-CO-16, BR-CO-25
 */
public class DuePayableAmount extends InlineRam {
	/**
	 * neues Tag
	 * @param amount einzusetzender Betrag
	 */
	public DuePayableAmount(long amount) {
		super("DuePayableAmount");
		content(amount);
	}
}
