/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.CountryCode;
import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: qdt:CountryIDType
 * Hinweis: Die Listen der zugelassenen Länder werden von der EN ISO 3166-1 Maintenance Agency
 *          „Codes for the representation of names of countries and their subdivisions” geführt.
 * Kardinalität: 1 .. 1
 * Anwendung: Der Code, der das Land angibt, aus dem die Ware stammt / in dem die Umsatzsteuer anfällt
 */
public class CountryID extends InlineRam {
	/**
	 * neues Tag
	 * @param code einzusetzender Ländercode
	 */
	public CountryID(CountryCode code) {
		super("CountryID");
		content(code.name());
	}
}
