/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:AmountType
 * Hinweis: Zuschläge der Positionsebene sind in den Nettobeträgen der Rechnungspositionen enthalten, die addiert werden, um den Gesamtnettobetrag der Positionen zu erhalten.
 * Anwendung: Summe aller in der Rechnung enthaltenen Zuschläge der Dokumentenebene
 * Geschäftsregeln: BR-CO-12, BR-CO-13
 */
public class ChargeTotalAmount extends InlineRam {

	/**
	 * neue Instanz
	 * @param value die Summe der Beträge
	 */
	public ChargeTotalAmount(long value) {
		super("ChargeTotalAmount");
		content(value);
	}
}
