/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:AmountType
 * Hinweis: Der Nettopreis muss gleich dem Bruttopreis abzüglich des Nachlass auf den Artikelpreis sein.
 * Kardinalität: 1 .. 1
 * Anwendung: Der Preis eines Artikels ohne Umsatzsteuer nach Abzug des Nachlass auf den Artikelpreis
 * Geschäftsregel: BR-26, BR-27
 */
public class ChargeAmount extends InlineRam {
	/**
	 * neue Instanz
	 * @param unitPrice der Preis für eine Verkaufseinheit
	 */
	public ChargeAmount(long unitPrice) {
		super("ChargeAmount");
		content(unitPrice);
	}
}
