/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:AmountType
 * Hinweis: Wird durch Multiplikation des nach der Umsatzsteuerkategorie zu versteuernden Betrages
 *          mit dem für die betreffende Umsatzsteuerkategorie geltenden Umsatzsteuersatz berechnet.
 *  Kardinalität: 1 … 1
 *  Anwendung: Der für die betreffende Umsatzsteuerkategorie zu entrichtende Gesamtbetrag
 *  Geschäftsregeln: BR-46, BR-CO-14, BR-CO-17, BR-AE-9, BR-E-9, BR-G-9, BR-IC-9, BR-IG-9, BR-IP-9, BR-O-9, BR-S-9, BR-Z-9
 */
public class CalculatedAmount extends InlineRam {

	/**
	 * neue Instanz
	 * @param value einzusetzender Wert
	 */
	public CalculatedAmount(long value) {
		super("CalculatedAmount");
		content(value);
	}
}
