/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:TradePartyType
 * Kardinalität: 1 … 1
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über den Käufer enthält
 */
public class BuyerTradeParty extends Ram {

	/**
	 * Neue Instanz
	 * @param name Käufer-Name
	 */
	public BuyerTradeParty(String name) {
		super("BuyerTradeParty");
		// optional@BasicWL, Basic, EN16931: ID
		// optional@BasicWL, Basic, EN16931: GlobalID
		add(new Name(name));
		// optional@Minimum,BasicWL, Basic, EN16931: SpecifiedLegalOrganization
		// optional@EN16931: DefinedTradeContact
		// +BasicWL: PostalTradeAddress
		// optional@BasicWL: URIUniversalCommunication
		// optional@BasicWL: SpecifiedTaxRegistration
	}
}
