/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.UnitCode;
import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:QuantityType
 * Kardinalität: 1 .. 1
 * Anwendung: Die Menge der in der betreffenden Zeile in Rechnung gestellten Einzelartikel (Waren oder Dienstleistungen)
 */
public class BilledQuantity extends InlineRam {

	/**
	 * erzeugt eine neue Instanz
	 * @param amount die einzusetzende Mänge
	 * @param unitCode der einzusetzende Code für die Verkaufseinheit
	 */
	public BilledQuantity(double amount, UnitCode unitCode) {
		super("BilledQuantity");
		attr("unitCode",unitCode.toString());
		content(amount+"");
	}
}
