/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.InlineRam;

/**
 * Datentyp: udt:AmountType
 * Hinweis: Die Summe des Gesamtnettobetrags der Positionen zuzüglich der Zuschläge
 *          abzüglich der Abschläge der Dokumentenebene, für die ein bestimmter Code
 *          der Umsatzsteuerkategorie und ein bestimmter Umsatzsteuersatz gelten
 *          (falls ein kategoriespezifischer Umsatzsteuersatz gilt).
 * Kardinalität: 1 … 1
 * Anwendung: Summe aller zu versteuernden Beträge, für die ein bestimmter Code der
 *            Umsatzsteuerkategorie und ein bestimmter Umsatzsteuersatz gelten
 *            (falls ein kategoriespezifischer Umsatzsteuersatz gilt)
 */
public class BasisAmount extends InlineRam {

	/**
	 * erzeugt ein neues Tag mit der angegeben Anzahl als Inhalt
	 * @param amount die Anzahl, die im Tag verwendet werden soll
	 */
	public BasisAmount(long amount) {
		super("BasisAmount");
		content(amount);
	}
}
