/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.LineItem;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:DocumentLineDocumentType
 * Kardinalität: 1 … 1
 */
public class AssociatedDocumentLineDocument extends Ram {
	/** the line id child **/ private final LineID lineId;

	/**
	 * erzeugt ein neues Tag
	 * @param lineItem daten über die Position, welche das Tag repräsentiert
	 */
	public AssociatedDocumentLineDocument(LineItem lineItem) {
		super("AssociatedDocumentLineDocument");
		add(lineId = new LineID(lineItem.number()));
		var notes = lineItem.notes();
		if (notes != null){
			for (String note : notes) add(new IncludedNote(note)); // optional
		}
	}

	/**
	 * get the LineID tag
	 * @return the LineID tag
	 */
	public LineID lineID(){
		return lineId;
	}
}
