/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.CombinedTaxSet;
import de.srsoftware.document.zugferd.data.TaxSet;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:TradeTaxType
 * Kardinalität: 1 .. unbounded
 * Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über die Umsatzsteueraufschlüsselung in verschiedene Kategorien, Sätze und Befreiungsgründe enthält
 */
public class ApplicableTradeTax extends Ram {
	/**
	 * erzeugt ein neues Tag
	 * @param taxSet die einzuschließenden Steuer-Daten
	 */
	public ApplicableTradeTax(TaxSet taxSet) {
		super("ApplicableTradeTax");
		if (taxSet instanceof CombinedTaxSet combined) add(new CalculatedAmount(combined.calculatedAmount()));
		add(new TypeCodeVAT());
		// optional@BasicWL, Basic, EN16931: ExemptionReason
		if (taxSet instanceof CombinedTaxSet combined) add(new BasisAmount(combined.basisAmount()));
		add(new CategoryCode(taxSet.type()));
		// optional@BasicWL, Basic, EN16931: ExemptionReasonCode
		// optional@EN16931: TaxPointDate
		// optional@BasicWL, Basic, EN16931: DueDateTypeCode
		add(new RateApplicablePercent(taxSet.percent())); // optional@BasicWL, Basic, EN16931
	}
}
