/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Datentyp: ram:HeaderTradeSettlementType
 * Hinweis: Diese Gruppe darf genutzt werden, um in der Rechnung vorweg anzugeben, dass die Zahlung über SEPA oder ein
   anderes vom Verkäufer eingeleitetes Lastschriftverfahren erfolgt, in Übereinstimmung mit den Regeln des SEPA-
   oder anderweitigen Lastschriftverfahrens.
   Anwendung: Eine Gruppe von betriebswirtschaftlichen Begriffen, die Informationen über eine Lastschrift enthält
 */
public class ApplicableHeaderTradeSettlement extends Ram {
	/** internes Tag **/ private final SpecifiedTradeSettlementHeaderMonetarySummation specifiedTradeSettlementHeaderMonetarySummation;

	/**
	 * erzeugt ein neues Handels-Vereinbarungs-Tag
	 * @param docData die Daten, mit denen das Tag befüllt wird
	 */
	public ApplicableHeaderTradeSettlement(DocumentData docData) {
		super("ApplicableHeaderTradeSettlement");
		// optional@BasicWL, Basic, EN16931: CreditorReferenceID
		// optional@BasicWL, Basic, EN16931: PaymentReference
		// optional@BasicWL, Basic, EN16931: TaxCurrencyCode
		add(new InvoiceCurrencyCode(docData.currency()));
		// optional@BasicWL, Basic, EN16931: PayeeTradeParty
		// optional@BasicWL, Basic, EN16931: SpecifiedTradeSettlementPaymentMeans
		// +@BasicWL: ApplicableTradeTax
		// optional@BasicWL, Basic, EN16931: BillingSpecifiedPeriod
		// optional@BasicWL, Basic, EN16931: SpecifiedTradeAllowanceCharge
		// optional@BasicWL, Basic, EN16931: SpecifiedTradePaymentTerms
		add(specifiedTradeSettlementHeaderMonetarySummation = new SpecifiedTradeSettlementHeaderMonetarySummation(docData));
		// optional@BasicWL, Basic, EN16931: InvoiceReferencedDocument
		// optional@BasicWL, Basic, EN16931: ReceivableSpecifiedTradeAccountingAccount
	}

	/**
	 * liefert das untergeordnete Tag SpecifiedTradeSettlementHeaderMonetarySummation zurück, damit es weiter modifiziert werden kamm
	 * @return das untergeordnete Tag SpecifiedTradeSettlementHeaderMonetarySummation
	 */
	public SpecifiedTradeSettlementHeaderMonetarySummation specifiedTradeSettlementHeaderMonetarySummation(){
		return specifiedTradeSettlementHeaderMonetarySummation;
	}
}
