/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.base.Ram;

/**
 * Anwendung: Gruppierung der Vertragsangaben
 * Kardinalität: 1 .. 1
 * Datentyp: ram:HeaderTradeAgreementType
 */
public class ApplicableHeaderTradeAgreement extends Ram {

	/** Verkäufer **/ private final SellerTradeParty sellerTradeParty;
	/** Käufer **/    private final BuyerTradeParty buyerTradeParty;

	/**
	 * neues Tag erzeugen
	 * @param docData Daten, um den Content zu befüllen
	 */
	public ApplicableHeaderTradeAgreement(DocumentData docData) {
		super("ApplicableHeaderTradeAgreement");
		// optional@Minimum, BasicWL, Basic, EN16931: BuyerReference
		add(sellerTradeParty = new SellerTradeParty(docData.author()));
		add(buyerTradeParty = new BuyerTradeParty(docData.customer().name()));
		// optional@BasicWL, Basic: SellerTaxRepresentativeTradeParty
		// optional@EN16931: SellerOrderReferencedDocument
		// optional@Minimum,BasicWL, Basic, EN16931: BuyerOrderReferencedDocument
		// optional@EN16931: ContractReferencedDocument
		// optional@EN16931: AdditionalReferencedDocument
		// optional@EN16931: SpecifiedProcuringProject
	}

	/**
	 * liefert das erzeugte Käufer-Tag (zur späteren Modifikation) zurück
	 * @return das BuyerTradeParty-Tag
	 */
	public BuyerTradeParty buyerTradeParty() {
		return buyerTradeParty;
	}

	/**
	 * liefert das erzeugte Verkäufer-Tag (zur späteren Modifikation) zurück
	 * @return das SellerTradeParty-Tag
	 */
	public SellerTradeParty sellerTradeParty(){
		return sellerTradeParty;
	}
}
