/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.tags.ram;

import de.srsoftware.document.zugferd.tags.base.Ram;
import java.time.LocalDate;

/**
 * Datentyp: ram:SupplyChainEventType
 * Kardinalität: 0 … 1
 */
public class ActualDeliverySupplyChainEvent extends Ram {

	/**
	 * neues Lieferdatum erzeugen
	 * @param deliveryDate das Lieferdatum, welches ins XML eingefügt werden soll
	 */
	public ActualDeliverySupplyChainEvent(LocalDate deliveryDate) {
		super("ActualDeliverySupplyChainEvent");
		add(new OccurrenceDateTime(deliveryDate));
	}
}
