/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.data;

/**
 * Die Maßeinheit muss aus den Listen aus
 * UN/ECE Recommendation No. 20 „Codes for Units of Measure Used in International Trade“ und
 * UN/ECE Recommendation No. 21 „Codes for Passengers, Types of Cargo, Packages and Packaging Materials (…)“
 * unter Anwendung des in UN/ECE Rec No. 20 Intro 2.a) beschriebenen Verfahrens ausgewählt werden.
 * Es ist zu beachten, dass es in den meisten Fällen für Käufer und Verkäufer nicht notwendig ist,
 * diese Listen vollständig in ihre Software zu implementieren.
 * Verkäufer brauchen nur die für ihre Waren und Dienstleistungen erforderlichen Einheiten zu unterstützen;
 * Käufer brauchen nur zu überprüfen, dass die in der Rechnung verwendeten Einheiten mit den in anderen Dokumenten
 * (wie z. B. in Verträgen, Kata-logen, Bestellungen und Lieferavise) verwendeten Einheiten übereinstimmen.
 *
 * Siehe: <a href="https://unece.org/trade/uncefact/cl-recommendations">Code List Recommendations</a>
 */
public enum UnitCode {
	/** Pro Jahr **/ per_year("H09"),
	/** Pauschal **/ fixed("1I"),
	/** Stunden **/ hours("LH"),
	/** Stück **/ pieces("H87");

	private final String code;

	UnitCode(String code) {
		this.code = code;
	}

	@Override
	public String toString() {
		return code;
	}
}
