/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.data;

/**
 * Interface für Steuer-Daten
 */
public interface TaxSet {

	/**
	 * zu verwendeter Steuersatz
	 * @return Prozentangabe
	 */
	public long percent();

	/**
	 * zu verwendender Steuer-Typ
	 * @return zu verwendender Steuer-Typ
	 */
	public TaxType type();

	/**
	 * erzeugt einen Schlüssel zur Unterbringung des Objekts in Maps
	 * @return type + "@" + percent
	 */
	public default String key() {
		return type() + "@" + percent();
	}
}
