/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.data;

import java.util.List;

/**
 * Daten für eine Rechnungsposition
 * @param number Positions-Nummer
 * @param id Artikel-Code
 * @param name Name der Position
 * @param notes Anmerkungen
 * @param unitPrice Preis pro Einheit des Postens
 * @param unit Einheit des Postens
 * @param amount Menge
 * @param taxSet Steuersatz
 * @param description Beschreibung
 */
public record LineItem(int number, String id, String name, String description, List<String> notes, long unitPrice, UnitCode unit, double amount, LineItemTaxSet taxSet) {
	/**
	 * Positions-Summe
	 * @return Produkt aus Menge und Preis pro Einheit
	 */
	public long totalAmount() {
		return Math.round(unitPrice * amount);
	}
}
