/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.data;

import static java.text.MessageFormat.format;

import java.util.Map;

/**
 * Interface für Converter. Dienen dazu, Maps in DocumentData zu konvertieren.
 */
public interface Converter {
	/**
	 * Klasse für Konversions-Fehler, die in der convert-Methode geworfen werden können
	 */
	public static class ConversionError extends Exception{
		/**
		 * neue Exception erzeugen
		 * @param message die Fehlermeldung, die der Exception mitgegeben wird
		 * @param fills Füll-Objekte für die formatierte Message
		 */
		public ConversionError(String message, Object...fills) {
			super(format(message,fills));
		}
	}

	/**
	 * wandelt ein Daten-Map in ein DocumentData-Objekt um
	 * @param data die Daten repräsentiert als (geschachteltes) Map
	 * @return ein DocumentData-Objekt mit den Daten des data-Objekts
	 * @throws ConversionError falls das data-Objekt nicht umgewandelt werden kann
	 */
	public DocumentData convert(Map<String, Object> data) throws ConversionError;
}
