/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd.data;


import java.util.Objects;

/**
 * Umsatzsteuerdaten für die Gesamtrechnung
 */
public final class CombinedTaxSet implements TaxSet {
	private long basisAmount;
	private final long percent;
	private final TaxType type;

	/**
	 * neuer Datensatz
	 * @param basisAmount zugrundeliegende Menge
	 * @param percent zugrundeliegender Steuersatz
	 * @param type Art der Steuer
	 */
	public CombinedTaxSet(long basisAmount, long percent, TaxType type) {
		this.basisAmount = basisAmount;
		this.percent = percent;
		this.type = type;
	}

	/**
	 * Menge um die angegebene Menge erhöhen
	 * @param amount Summand für die Menge
	 */
	public void add(long amount) {
		basisAmount+=amount;
	}

	/**
	 * zugrundeliegende Menge zurückgeben
	 * @return Summe der mit add(long amount) hinzugefügten Werte
	 */
	public long basisAmount() {
		return basisAmount;
	}

	/**
	 * berechnet die Steuer-Summ
	 * @return zugrundeliegende Menga &times; Steuersatz / 100
	 */
	public long calculatedAmount() {
		return basisAmount() * percent() / 10000;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) return true;
		if (obj == null || obj.getClass() != this.getClass()) return false;
		var that = (CombinedTaxSet) obj;
		return this.basisAmount == that.basisAmount &&
				this.percent == that.percent &&
				Objects.equals(this.type, that.type);
	}

	@Override
	public int hashCode() {
		return Objects.hash(basisAmount, percent, type);
	}

	@Override
	public long percent() {
		return percent;
	}

	@Override
	public String toString() {
		return "CombinedTaxSet[" +
				"basisAmount=" + basisAmount + ", " +
				"percent=" + percent + ", " +
				"type=" + type + ']';
	}

	@Override
	public TaxType type() {
		return type;
	}
}
