/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import de.srsoftware.document.api.DocumentRegistry;
import java.util.stream.Stream;

/**
 * Factory to add documents related to Zugferd specification to a registry
 */
public class ZugferdFactory implements DocumentFactory {

	private DocumentRegistry registry;

	/**
	 * create new instance
	 */
	public ZugferdFactory(){
	}

	@Override
	public String description() {
		return "Zugferd-Dokumente";
	}

	@Override
	public Stream<Document> documents() {
		return Stream.of(new Minimum(),new BasicWL(),new Basic(),new EN16931(), new Zugferd(registry));
	}

	@Override
	public DocumentFactory setRegistry(DocumentRegistry registry) {
		this.registry = registry;
		return DocumentFactory.super.setRegistry(registry);
	}
}
