/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd;





import static de.srsoftware.document.mustang.Constants.KEY_DATA;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.api.StringContent;
import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.ram.*;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;
import de.srsoftware.tools.MimeType;
import java.util.Map;

/**
 * Dokument, das beim Rendern factura-X-XML nach dem Profil „Minimum“ erzeugt
 */
public class Minimum implements Document {
	private static final String MINIMUM = "urn:factur-x.eu:1p0:minimum";

	/**
	 * Erzeugt eine neue Instanz
	 */
	public Minimum(){
		super();
	}

	@Override
	public String description() {
		return "Factur-X-genormtes Dokument";
	}

	@Override
	public String id() {
		return "Factur-X@Minimum";
	}

	/**
	 * this is used in derived classes to add mor data to the document
 	 * @param document the invoice to alter
	 * @param docData data data used to alter the invoice
	 */
	public void intercept(CrossIndustryInvoice document, DocumentData docData) {
	}

	/**
	 * gibt das Level dieses Dokuments zurück
	 * @return "urn:factur-x.eu:1p0:minimum"
	 */
	protected String level() {
		return MINIMUM;
	}

	@Override
	public String mimeType() {
		return MimeType.MIME_XML;
	}

	@Override
	public String name() {
		return "factur-x.xml";
	}

	private RenderResult render(DocumentData docData){
		var document = new CrossIndustryInvoice(docData,level());
		intercept(document,docData);
		return new StringContent("<?xml version='1.0' encoding='UTF-8' ?>\n"+document.toString(2));
	}

	@Override
	public RenderResult render(Map<String, Object> data) {
		if (!data.containsKey(KEY_DATA)) return RenderError.of("Data does not contain key \"{}\"!",KEY_DATA);
		var o = data.get(KEY_DATA);
		if (o instanceof DocumentData documentData) return render(documentData);
		return RenderError.of("Value for key \"docData\" is invalid: {}",o);
	}
}
