/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.ram.Description;
import de.srsoftware.document.zugferd.tags.ram.IncludedSupplyChainTradeLineItem;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;

/**
 * Dokument, das beim Rendern factura-X-XML nach dem Profil „EN16931“ erzeugt
 */
public class EN16931 extends Basic {

	private static final String EN16931LEVEL = "urn:cen.eu:en16931:2017";

	/**
	 * Erzeugt eine neue Instanz
	 */
	public EN16931() {
		super();
	}

	@Override
	public String id() {
		return "Factur-X@EN16931";
	}

	@Override
	public void intercept(CrossIndustryInvoice document, DocumentData docData) {
		super.intercept(document, docData);
		var map = document.supplyChainTradeTransaction().lineItems();
		for (var lineItem : docData.lineItems()){
			if (lineItem.description() == null || lineItem.description().isBlank()) continue;
			if (map.get(lineItem.number()) instanceof IncludedSupplyChainTradeLineItem tag) tag.specifiedTradeProduct().add(new Description(lineItem.description()));
		}
	}

	@Override
	protected String level() {
		return EN16931LEVEL;
	}
}
