/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.ram.*;
import de.srsoftware.document.zugferd.tags.ram.ApplicableTradeTax;
import de.srsoftware.document.zugferd.tags.ram.ChargeTotalAmount;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;

/**
 * Dokument, das beim Rendern factura-X-XML nach dem Profil „Basic Without Lines“ erzeugt
 */
public class BasicWL extends Minimum{
	private static final String BASIC_WL = "urn:factur-x.eu:1p0:basicwl";

	/**
	 * Erzeugt eine neue Instanz
	 */
	public BasicWL(){
		super();
	}

	@Override
	public String id() {
		return "Factur-X@BasicWL";
	}


	@Override
	public void intercept(CrossIndustryInvoice document, DocumentData docData) {
		super.intercept(document, docData);
		var exchangedDocument = document.exchangedDocument();
		var transaction = document.supplyChainTradeTransaction();
		var agreement = transaction.applicableHeaderTradeAgreement();
		var seller = agreement.sellerTradeParty();
		var buyer = agreement.buyerTradeParty();
		var delivery = transaction.applicableHeaderTradeDelivery();
		var settlement = transaction.applicableHeaderTradeSettlement();
		var summation = settlement.specifiedTradeSettlementHeaderMonetarySummation();
		for (var note : docData.notes()) exchangedDocument.add(new IncludedNote(note));

		// optional: sellerTradeParty.ID
		// optional: sellerTradeParty.GlobalID
		var sellerAddress = seller.postalTradeAddress();
		sellerAddress.add(
				new PostcodeCode(docData.author().postCode()), // optional
				new LineOne(docData.author().streetAddress()),
				// optional: LineTwo
				// optional: LineThree
				new CityName(docData.author().city()), // optional
				sellerAddress.children().getFirst()); // move CountryID to end
				// optional: sellerAddress.CountrySubDivisionName
		// optional: sellerTradeParty.URIUniversalCommunication
		var buyerAddress = new PostalTradeAddress(docData.customer().countryId());
			buyerAddress.add(
					new PostcodeCode(docData.customer().postCode()),
					new LineOne(docData.customer().streetAddress()),
					new CityName(docData.customer().city()),
					buyerAddress.children().getFirst());

		buyer.add(buyerAddress);
		delivery.add(new ActualDeliverySupplyChainEvent(docData.deliveryDate()));
		for (var taxSet : docData.taxSets()) settlement.add(new ApplicableTradeTax(taxSet));
		settlement.add(new SpecifiedTradePaymentTerms(docData));
		summation.addFirst(new ChargeTotalAmount(docData.chargeTotalAmount()))
				.addFirst(new LineTotalAmount(docData.taxBasisTotalAmount()));
		settlement.add(summation);
	}



	@Override
	protected String level() {
		return BASIC_WL;
	}
}
