/* © SRSoftware 2025 */
package de.srsoftware.document.zugferd;

import de.srsoftware.document.zugferd.data.DocumentData;
import de.srsoftware.document.zugferd.tags.ram.IncludedSupplyChainTradeLineItem;
import de.srsoftware.document.zugferd.tags.rsm.CrossIndustryInvoice;

/**
 * Dokument, das beim Rendern factura-X-XML nach dem Profil „Basic“ erzeugt
 */
public class Basic extends BasicWL {

	private static final String BASIC = "urn:cen.eu:en16931:2017#compliant#urn:factur-x.eu:1p0:basic";

	/**
	 * Erzeugt eine neue Instanz
	 */
	public Basic() {
		super();
	}

	@Override
	public String id() {
		return "Factur-X@Basic";
	}


	@Override
	public void intercept(CrossIndustryInvoice document, DocumentData docData) {
		super.intercept(document, docData);
		var supplyChainTradeTransaction = document.supplyChainTradeTransaction();
		docData.lineItems()
				.stream()
				.sorted((a,b)->b.number()-a.number())
				.map(IncludedSupplyChainTradeLineItem::new)
				.forEach(supplyChainTradeTransaction::addFirst);
	}

	@Override
	protected String level() {
		return BASIC;
	}
}
