/* © SRSoftware 2025 */
package de.srsoftware.document.mustang;

import static de.srsoftware.document.mustang.Constants.*;

import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPSchema;

/**
 * Code adapted from Mustangproject's ZUGFeRD implementation
 * @author jstaerk, srichter
 **/
public class ZugferdSchema extends XMPSchema {

	/***
	 * This is what needs to be added to the RDF metadata - basically the name of the embedded Zugferd file
	 *
	 * @param metadata the xmp to be added to
	 * @param conformanceLevel e.g.  conformanceLevel.EN16931
	 * @param filename the filename of the invoice
	 */
	public ZugferdSchema(XMPMetadata metadata, String conformanceLevel, String filename) {
		super(metadata, NAMESPACE_FACTUR_X, PREFIX_FACTUR_X, ZF_SCHEMA_NAME);
		setAboutAsSimple("");
		setTextPropertyValue(CONFORMANCE_LEVEL, conformanceLevel);
		setTextPropertyValue(DOC_TYPE, INVOICE);
		setTextPropertyValue(DOC_FILENAME, filename);

		setTextPropertyValue(VERSION, DEFAULT_ZF_SCHEMA_VERSION);
	}
}
