/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.files;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.api.StreamContent;
import de.srsoftware.tools.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class FileGenerator
implements Document {
    private static final System.Logger LOGGER = System.getLogger(FileGenerator.class.getSimpleName());
    private final File source;

    public FileGenerator(File file) {
        this.source = file;
    }

    public RenderResult render(Map<String, Object> data) {
        try {
            return StreamContent.of((InputStream)new FileInputStream(this.source), (String)this.mimeType());
        }
        catch (IOException e) {
            return RenderError.of((String)"Failed to render \"{0}\"", (Object[])new Object[]{this.id()}).add((Exception)e);
        }
    }

    public String id() {
        return this.source.toString();
    }

    public String mimeType() {
        return MimeType.guessMime((File)this.source);
    }

    public String description() {
        return "Contents of file %s".formatted(this.source);
    }

    public String toString() {
        return "%s (%s)".formatted(this.id(), this.getClass().getSimpleName());
    }
}

