/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.files;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import de.srsoftware.document.files.FileGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Stream;

public class DocumentDirectory
implements DocumentFactory {
    private final File dir;

    public DocumentDirectory(File directory) {
        this.dir = directory;
    }

    public String id() {
        return this.dir.toString();
    }

    public String description() {
        return "Documents loaded from %s".formatted(this.dir);
    }

    public Stream<Document> documents() {
        if (!this.dir.exists()) {
            return Stream.of(new Document[0]);
        }
        if (!this.dir.isDirectory()) {
            return Stream.of(new Document[0]);
        }
        File[] files = this.dir.listFiles();
        if (files == null || files.length < 1) {
            return Stream.of(new Document[0]);
        }
        ArrayList<FileGenerator> list = new ArrayList<FileGenerator>();
        for (File entry : files) {
            if (entry.isDirectory() || !entry.canRead()) continue;
            list.add(new FileGenerator(entry));
        }
        return list.stream();
    }
}

