/* © SRSoftware 2025 */
package de.srsoftware.document.files;

import static de.srsoftware.tools.MimeType.guessMime;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.RenderError;
import de.srsoftware.document.api.RenderResult;
import de.srsoftware.document.api.StreamContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

/**
 *  Document that renders by loading a file into an input stream
 */
public class FileGenerator implements Document {
	private static final System.Logger LOGGER = System.getLogger(FileGenerator.class.getSimpleName());
	private final File	   source;

	/**
	 * create a new file-backed Document
	 * @param file the file to load upon rendering
	 */
	public FileGenerator(File file) {
		source = file;
	}

	@Override
	public RenderResult render(Map<String, Object> data) {
		try {
			return StreamContent.of(new FileInputStream(source),mimeType());
		} catch (IOException e) {
			return RenderError.of("Failed to render \"{0}\"", id()).add(e);
		}
	}

	@Override
	public String id() {
		return source.toString();
	}

	@Override
	public String mimeType() {
		return guessMime(source);
	}

	@Override
	public String description() {
		return "Contents of file %s".formatted(source);
	}

	@Override
	public String toString() {
		return "%s (%s)".formatted(id(), getClass().getSimpleName());
	}
}
