/* © SRSoftware 2025 */
package de.srsoftware.document.files;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Stream;

/**
 * DocumentFactory based on a local directory.
 * This Factory provides the files located in a given directory as documents
 */
public class DocumentDirectory implements DocumentFactory {
	private final File dir;

	/**
	 * create a new Factory backed by the given directory
	 * @param directory a local file system directory
	 */
	public DocumentDirectory(File directory) {
		this.dir = directory;
	}

	@Override
	public String id() {
		return dir.toString();
	}

	@Override
	public String description() {
		return "Documents loaded from %s".formatted(dir);
	}

	@Override
	public Stream<Document> documents() {
		if (!dir.exists()) return Stream.of();
		if (!dir.isDirectory()) return Stream.of();
		var files = dir.listFiles();
		if (files == null || files.length < 1) return Stream.of();
		var list = new ArrayList<Document>();
		for (var entry : files) {
			if (entry.isDirectory()) continue;
			if (!entry.canRead()) continue;
			list.add(new FileGenerator(entry));
		}
		return list.stream();
	}
}
