/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.api;

import de.srsoftware.document.api.Content;
import de.srsoftware.document.api.RenderResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class StreamContent
implements Content,
RenderResult {
    private final InputStream stream;

    public StreamContent(InputStream stream) {
        this.stream = stream;
    }

    public static RenderResult of(InputStream stream) {
        return new StreamContent(stream);
    }

    @Override
    public byte[] bytes() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.stream.transferTo(bos);
            this.stream.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream inputStream() {
        return this.stream;
    }

    public String toString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.stream.transferTo(bos);
            this.stream.close();
            return bos.toString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

