/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.api;

import de.srsoftware.document.api.RenderResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RenderError
implements RenderResult {
    private List<Exception> exceptions = new ArrayList<Exception>();
    private String message;

    private RenderError(String message) {
        this.message = message;
    }

    public RenderError add(Exception e) {
        this.exceptions.add(e);
        return this;
    }

    public List<Exception> exceptions() {
        return this.exceptions;
    }

    public static RenderError of(String message) {
        return new RenderError(message);
    }

    public static RenderError of(String message, Object ... fills) {
        return new RenderError(MessageFormat.format(message, fills));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.message);
        if (!this.exceptions.isEmpty()) {
            sb.append(":");
        }
        for (Exception ex : this.exceptions) {
            sb.append("\n").append(ex.getMessage());
        }
        return sb.toString();
    }

    public Optional<RenderError> wrap() {
        return Optional.of(this);
    }
}

