/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.api;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class DocumentRegistry {
    private final Map<String, DocumentFactory> factories = new HashMap<String, DocumentFactory>();
    Map<String, Document> documents = new HashMap<String, Document>();

    public DocumentRegistry add(DocumentFactory factory) {
        this.factories.put(factory.getClass().getCanonicalName(), factory);
        this.rebuild();
        return this;
    }

    public Stream<Document> documents() {
        return this.documents.values().stream();
    }

    public DocumentRegistry remove(Class<?> clazz) {
        this.factories.remove(clazz.getCanonicalName());
        this.rebuild();
        return this;
    }

    private void rebuild() {
        int oldSize;
        HashMap<String, Document> current = new HashMap<String, Document>();
        do {
            oldSize = current.size();
            for (DocumentFactory factory : this.factories.values()) {
                List<Document> docs = factory.documents().toList();
                for (Document doc : docs) {
                    current.put(doc.id(), doc);
                }
            }
            this.documents = current;
        } while (current.size() != oldSize);
    }
}

