/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.configuration;

import de.srsoftware.configuration.Configuration;
import de.srsoftware.configuration.Locator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Optional;
import java.util.Stack;
import org.json.JSONObject;

public class JsonConfig
implements Configuration {
    private static final System.Logger LOG = System.getLogger(JsonConfig.class.getSimpleName());
    private final File file;
    private final JSONObject json;

    public JsonConfig(File jsonConfigurationFile) throws IOException {
        this.file = jsonConfigurationFile;
        if (this.file.isDirectory()) {
            throw new IllegalArgumentException("%s is a directory, file expected".formatted(this.file));
        }
        if (!this.file.exists()) {
            try (FileWriter out = new FileWriter(this.file);){
                out.write("{}\n");
            }
        }
        LOG.log(System.Logger.Level.INFO, "Loading json config file from {0}\u2026", this.file);
        this.json = new JSONObject(Files.readString(this.file.toPath()));
    }

    public JsonConfig(JSONObject json) {
        this.file = null;
        this.json = json;
    }

    public JsonConfig(String applicationName) throws IOException {
        this(Locator.locateConfig((String)applicationName, (String)"json"));
    }

    public <C extends Configuration> C drop(String key) throws IOException {
        this.drop(this.json, this.toPath(key));
        return (C)this;
    }

    private void drop(JSONObject json, Stack<String> path) {
        String key = path.pop();
        if (!json.has(key)) {
            return;
        }
        if (path.isEmpty()) {
            json.remove(key);
            return;
        }
        Object object = json.get(key);
        if (object instanceof JSONObject) {
            JSONObject inner = (JSONObject)object;
            this.drop(inner, path);
        }
    }

    public File file() {
        return this.file;
    }

    public String flat() {
        return this.json.toString();
    }

    public <T> Optional<T> get(String key) {
        return Optional.ofNullable(this.get(this.json, this.toPath(key), null));
    }

    public <T> T get(String key, T defaultValue) {
        return this.get(this.json, this.toPath(key), defaultValue);
    }

    private <T> T get(JSONObject json, Stack<String> path, T defaultValue) {
        String key = path.pop();
        if (path.isEmpty()) {
            if (json.has(key)) {
                try {
                    return (T)json.get(key);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            json.put(key, defaultValue);
            return defaultValue;
        }
        if (!json.has(key)) {
            if (defaultValue != null) {
                JSONObject inner = new JSONObject();
                this.set(inner, path, defaultValue);
                json.put(key, (Object)inner);
            }
            return defaultValue;
        }
        Object inner = json.get(key);
        if (!(inner instanceof JSONObject)) {
            if (defaultValue != null) {
                inner = new JSONObject();
                this.set((JSONObject)inner, path, defaultValue);
                json.put(key, inner);
            }
            return defaultValue;
        }
        return this.get((JSONObject)inner, path, defaultValue);
    }

    public Collection<String> keys() {
        return this.json.keySet();
    }

    public void save() throws IOException {
        Files.writeString(this.file.toPath(), (CharSequence)this.json.toString(2), new OpenOption[0]);
    }

    public <C extends Configuration> C set(String key, Object value) throws IOException {
        this.set(this.json, this.toPath(key), value);
        return (C)this;
    }

    private void set(JSONObject json, Stack<String> path, Object value) {
        String key = path.pop();
        if (path.empty()) {
            json.put(key, value);
        } else {
            Object inner;
            if (!json.has(key)) {
                json.put(key, (Object)new JSONObject());
            }
            if (!((inner = json.get(key)) instanceof JSONObject)) {
                inner = new JSONObject();
                json.put(key, inner);
            }
            this.set((JSONObject)inner, path, value);
        }
    }

    public Optional<JsonConfig> subset(String key) {
        Optional<JSONObject> json = this.get(key);
        return json.map(JsonConfig::new);
    }

    private Stack<String> toPath(String key) {
        String[] parts = key.split("\\.");
        Stack<String> path = new Stack<String>();
        for (int i = parts.length; i > 0; --i) {
            path.push(parts[i - 1]);
        }
        return path;
    }

    public String toString() {
        return this.json.toString(2);
    }
}

