/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.impl.StereotypeImpl;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.model.MAttribute;
import de.spraener.nxtgen.oom.model.MClass;
import de.spraener.nxtgen.oom.model.MPackage;
import java.util.function.Consumer;

public class ResourceToTSType
implements Transformation {
    public void doTransformation(ModelElement element) {
        if (!(element instanceof MClass)) {
            return;
        }
        if (!((MClass)element).hasStereotype(RESTStereotypes.RESSOURCE.getName())) {
            return;
        }
        this.create((MClass)element);
    }

    public MClass create(MClass mClass) {
        MPackage tsTypePkg = mClass.getPackage().findOrCreatePackage("tstype");
        MClass tsType = tsTypePkg.createMClass(mClass.getName());
        StereotypeImpl sType = new StereotypeImpl(RESTStereotypes.TSTYPE.getName(), new Consumer[0]);
        tsType.getStereotypes().add(sType);
        mClass.getAttributes().forEach(attr -> {
            MAttribute tsAttr = tsType.createAttribute(attr.getName(), this.toTSType((MAttribute)attr));
        });
        return tsType;
    }

    private String toTSType(MAttribute attr) {
        String t = attr.getType().toLowerCase();
        if ("long".equals(t = t.replaceAll("java.lang.", ""))) {
            return "number";
        }
        if ("integer".equals(t) || "int".equals(t)) {
            return "number";
        }
        if ("double".equals(t) || "float".equals(t)) {
            return "number";
        }
        if ("boolean".equals(t)) {
            return "boolean";
        }
        if ("string".equals(t)) {
            return "string";
        }
        if ("date".equals(t)) {
            return "Date";
        }
        if (this.isLinkReference(attr)) {
            return "ResourceLink";
        }
        return "any";
    }

    private boolean isLinkReference(MAttribute attr) {
        return StereotypeHelper.hasStereotype((ModelElement)attr, (String)RESTStereotypes.LINK.getName());
    }
}

