/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.impl.StereotypeImpl;
import de.spraener.nxtgen.oom.model.MClass;
import de.spraener.nxtgen.oom.model.MOperation;
import de.spraener.nxtgen.oom.model.MPackage;
import java.util.function.Consumer;

public class ResourceToLogic
implements Transformation {
    public void doTransformation(ModelElement element) {
        if (!(element instanceof MClass)) {
            return;
        }
        if (!((MClass)element).hasStereotype(RESTStereotypes.RESSOURCE.getName())) {
            return;
        }
        this.create((MClass)element);
    }

    public MClass create(MClass mClass) {
        MPackage pkgLogic = mClass.getPackage().findOrCreatePackage("logic");
        MClass logicBase = pkgLogic.createMClass(mClass.getName() + "LogicBase");
        logicBase.setModel(mClass.getModel());
        logicBase.setProperty("originalClass", mClass.getFQName());
        StereotypeImpl stType = new StereotypeImpl(RESTStereotypes.LOGIC.getName(), new Consumer[0]);
        logicBase.getStereotypes().add(stType);
        stType.setTaggedValue("dataType", mClass.getFQName() + "Entity");
        for (MOperation op : mClass.getOperations()) {
            MOperation opClone = op.cloneTo(logicBase);
            String type = ResourceToLogic.toLogicReturnType(opClone.getType());
            opClone.setType(type);
        }
        MClass logicImpl = pkgLogic.createMClass(mClass.getName() + "Logic");
        StereotypeImpl stTypeLogic = new StereotypeImpl(RESTStereotypes.IMPL.getName(), new Consumer[0]);
        logicImpl.getStereotypes().add(stTypeLogic);
        logicImpl.setProperty("extends", logicBase.getFQName());
        logicImpl.setProperty("constructorArgs", mClass.getPackage().getFQName() + ".model." + mClass.getName() + "Repository repository, Gson gson");
        logicImpl.setProperty("superCallArgs", "repository, gson");
        logicImpl.setProperty("importList", "import org.springframework.stereotype.Component;\nimport com.google.gson.Gson;\n");
        logicImpl.setProperty("annotations", "@Component\n");
        for (MOperation op : mClass.getOperations()) {
            MOperation opClone = op.cloneTo(logicImpl);
            String type = ResourceToLogic.toLogicReturnType(opClone.getType());
            opClone.setType(type);
            op.setProperty("returnStatement", "return null;");
        }
        return logicBase;
    }

    public static String toLogicReturnType(String type) {
        if (type.indexOf("de.") > -1) {
            return type.substring(0, type.lastIndexOf(46)) + ".model." + type.substring(type.lastIndexOf(46) + 1);
        }
        return type;
    }
}

