/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.NextGen;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToEntityBase;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Stereotype;
import de.spraener.nxtgen.model.impl.ModelElementImpl;
import de.spraener.nxtgen.model.impl.StereotypeImpl;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.model.MAssociation;
import de.spraener.nxtgen.oom.model.MAttribute;
import de.spraener.nxtgen.oom.model.MClass;
import de.spraener.nxtgen.oom.model.MClassRef;
import de.spraener.nxtgen.oom.model.MPackage;
import de.spraener.nxtgen.oom.model.OOModel;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class ResourceToEntity
extends ResourceToEntityBase {
    private static final Set<String> TABLENAME_KEYWORDS = new HashSet<String>();

    public static void ensureEntityDefinition(MClass mClass) {
        Stereotype sType = StereotypeHelper.getStereotype((ModelElement)mClass, (String)RESTStereotypes.ENTITY.getName());
        String tableName = sType.getTaggedValue("dbTable");
        if (tableName == null) {
            sType.setTaggedValue("dbTable", ResourceToEntity.toTableName(mClass));
        } else {
            sType.setTaggedValue("dbTable", tableName);
        }
        ResourceToEntity.ensureHasId(mClass);
        for (MAttribute a : mClass.getAttributes()) {
            ResourceToEntity.ensureEntityDefinition(a);
        }
        for (MAttribute a : mClass.getAssociations()) {
            ResourceToEntity.convertToEntityType((MAssociation)a);
        }
        ResourceToEntity.ensureSuperClassIsEntity(mClass);
    }

    private static void ensureSuperClassIsEntity(MClass mClass) {
        if (mClass.getInheritsFrom() != null) {
            MClass superClass = mClass.getInheritsFrom().getMClass(mClass.getModel());
            if (superClass == null) {
                NextGen.LOGGER.severe("InheritsFrom in Clas " + mClass.getName() + " points to " + mClass.getInheritsFrom().getFullQualifiedClassName() + " and is not resolveable");
            }
            if (!superClass.hasStereotype(RESTStereotypes.ENTITY.getName())) {
                String entitySuperClasName = superClass.getParent().getFQName() + ".model." + superClass.getName();
                mClass.setInheritsFrom(new MClassRef(entitySuperClasName));
            }
        }
    }

    public static void ensureEntityDefinition(MAttribute a) {
        if (!StereotypeHelper.hasStereotype((ModelElement)a, (String)RESTStereotypes.DBFIELD.getName())) {
            StereotypeImpl sType = new StereotypeImpl(RESTStereotypes.DBFIELD.getName(), new Consumer[0]);
            sType.setTaggedValue("dbFieldName", ResourceToEntity.toDbFieldName(a.getName()));
            sType.setTaggedValue("dbType", ResourceToEntity.toDbType(a.getType()));
            a.getStereotypes().add(sType);
        }
    }

    @Override
    public void doTransformationIntern(MClass element) {
        this.create(element);
    }

    public MClass create(MClass mClass) {
        MPackage pkg = mClass.getPackage();
        MPackage entityPkg = pkg.findOrCreatePackage("model");
        MClass entity = entityPkg.createMClass(mClass.getName());
        StereotypeImpl eSType = new StereotypeImpl(RESTStereotypes.ENTITY.getName(), new Consumer[0]);
        eSType.setTaggedValue("dbTable", ResourceToEntity.toTableName(mClass));
        entity.getStereotypes().add(eSType);
        for (Object attr : mClass.getAttributes()) {
            if (StereotypeHelper.hasStereotype((ModelElement)attr, (String)RESTStereotypes.LINK.getName())) {
                entity.addChilds(this.createLinkRelation((MAttribute)attr));
                continue;
            }
            entity.addAttribute(this.toDBField((MAttribute)attr));
        }
        OOModel ooModel = (OOModel)mClass.getModel();
        for (MAssociation assoc : mClass.getAssociations()) {
            MAssociation eAssoc = this.createFrom(assoc);
            ResourceToEntity.convertToEntityType(eAssoc);
            entity.getAssociations().add(eAssoc);
        }
        ResourceToEntity.ensureHasId(entity);
        MClass repo = entityPkg.createMClass(mClass.getName() + "Repository");
        StereotypeImpl repoSType = new StereotypeImpl(RESTStereotypes.REPOSITORY.getName(), new Consumer[0]);
        repo.addStereotypes((Stereotype)repoSType);
        repoSType.setTaggedValue("keyType", "Long");
        repoSType.setTaggedValue("dataType", entity.getFQName());
        StringBuffer attrList = new StringBuffer();
        for (MAttribute attr : mClass.getAttributes()) {
            if (attrList.length() > 0) {
                attrList.append(";");
            }
            attrList.append(attr.getName());
        }
        repoSType.setTaggedValue("attrList", attrList.toString());
        return entity;
    }

    private MAssociation createFrom(MAssociation assoc) {
        MAssociation result = new MAssociation();
        result.setModel(assoc.getModel());
        result.setAssociationType(assoc.getAssociationType());
        result.setAssocId(assoc.getAssocId());
        result.setComposite(assoc.getComposite());
        result.setMultiplicity(assoc.getMultiplicity());
        result.setOpositeAttribute(assoc.getOpositeAttribute());
        result.setOpositeMultiplicity(assoc.getOpositeMultiplicity());
        result.setType(assoc.getType());
        result.setName(assoc.getName());
        return result;
    }

    private static void convertToEntityType(MAssociation eAssoc) {
        String targetType = eAssoc.getType();
        if (targetType.contains("model")) {
            return;
        }
        Object targetPkg = targetType.substring(0, targetType.lastIndexOf(46));
        String targetClass = targetType.substring(targetType.lastIndexOf(46) + 1);
        if (!((String)targetPkg).endsWith("model")) {
            targetPkg = (String)targetPkg + ".model";
        }
        eAssoc.setType((String)targetPkg + "." + targetClass);
    }

    private ModelElement createLinkRelation(MAttribute attr) {
        ModelElementImpl e = new ModelElementImpl();
        StereotypeImpl st = new StereotypeImpl(RESTStereotypes.RSRCLINK.getName(), new Consumer[0]);
        e.getStereotypes().add(st);
        st.setTaggedValue("target", attr.getType());
        st.setTaggedValue("cardinality", attr.isToN() ? "*" : "1");
        return e;
    }

    public static void ensureHasId(MClass entity) {
        Stereotype sType;
        MAttribute aId = null;
        for (MAttribute a : entity.getAttributes()) {
            if (!a.getName().equals("id")) continue;
            aId = a;
            break;
        }
        if (aId == null) {
            aId = entity.createAttribute("id", "Long");
        }
        if ((sType = StereotypeHelper.getStereotype(aId, (String)RESTStereotypes.DBFIELD.getName())) == null) {
            sType = new StereotypeImpl(RESTStereotypes.DBFIELD.getName(), new Consumer[0]);
            sType.setTaggedValue("dbFieldName", ResourceToEntity.toDbFieldName(aId.getName()));
            sType.setTaggedValue("dbType", ResourceToEntity.toDbType(aId.getType()));
            aId.getStereotypes().add(sType);
        }
        sType.setTaggedValue("isKey", "true");
    }

    private MAttribute toDBField(MAttribute attr) {
        MAttribute dbField = new MAttribute((ModelElement)attr);
        StereotypeImpl sType = new StereotypeImpl(RESTStereotypes.DBFIELD.getName(), new Consumer[0]);
        sType.setTaggedValue("dbFieldName", ResourceToEntity.toDbFieldName(attr.getName()));
        sType.setTaggedValue("dbType", ResourceToEntity.toDbType(attr.getType()));
        dbField.getStereotypes().add(sType);
        return dbField;
    }

    public static String toTableName(MClass mClass) {
        Object tableName = mClass.getTaggedValue(RESTStereotypes.ENTITY.getName(), "dbTableName");
        if (tableName == null && TABLENAME_KEYWORDS.contains(tableName = ResourceToEntity.camelCaseToDbName(mClass.getName()))) {
            tableName = (String)tableName + "_TAB";
        }
        return tableName;
    }

    public static String toDbFieldName(String name) {
        return ResourceToEntity.camelCaseToDbName(name);
    }

    public static String toDbType(String type) {
        String dbType = "VARCHAR(256)";
        if ("Long".equals(type) || "java.lang.Long".equals(type)) {
            dbType = "BIGINT";
        }
        if ("Date".equals(type) || "java.util.Date".equals(type)) {
            dbType = "DATE";
        }
        if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            dbType = "INTEGER";
        }
        if ("Double".equals(type) || "java.lang.Double".equals(type)) {
            dbType = "DECIMAL(15,5)";
        }
        return dbType;
    }

    public static String camelCaseToDbName(String name) {
        StringBuilder sb = new StringBuilder();
        char prevChar = '\u0000';
        for (char c : name.toCharArray()) {
            if (Character.isUpperCase(c) && Character.isLowerCase(prevChar)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prevChar = c;
        }
        return sb.toString();
    }

    static {
        TABLENAME_KEYWORDS.add("USER");
    }
}

