/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToLogic;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.impl.StereotypeImpl;
import de.spraener.nxtgen.oom.model.MClass;
import de.spraener.nxtgen.oom.model.MOperation;
import java.util.function.Consumer;

public class ResourceToContoller
implements Transformation {
    public void doTransformation(ModelElement element) {
        if (!(element instanceof MClass)) {
            return;
        }
        if (!((MClass)element).hasStereotype(RESTStereotypes.RESSOURCE.getName())) {
            return;
        }
        this.create((MClass)element);
    }

    public MClass create(MClass mClass) {
        MClass cntrl = mClass.getPackage().createMClass(mClass.getName() + "ControllerBase");
        StereotypeImpl stType = new StereotypeImpl(RESTStereotypes.RESTCONTROLLER.getName(), new Consumer[0]);
        cntrl.getStereotypes().add(stType);
        stType.setTaggedValue("dataType", mClass.getFQName());
        for (MOperation op : mClass.getOperations()) {
            MOperation opClone = op.cloneTo(cntrl);
            String type = ResourceToLogic.toLogicReturnType(opClone.getType());
            opClone.setType(type);
            op.setProperty("returnStatement", "return null;");
        }
        MClass cntrlImpl = mClass.getPackage().createMClass(mClass.getName() + "Controller");
        StereotypeImpl stTypeImpl = new StereotypeImpl(RESTStereotypes.IMPL.getName(), new Consumer[0]);
        stTypeImpl.setTaggedValue("dataType", mClass.getFQName());
        cntrlImpl.getStereotypes().add(stTypeImpl);
        cntrlImpl.setProperty("extends", cntrl.getFQName());
        cntrlImpl.setProperty("constructorArgs", mClass.getPackage().getFQName() + ".logic." + mClass.getName() + "Logic logic");
        cntrlImpl.setProperty("superCallArgs", "logic");
        cntrlImpl.setProperty("annotations", "@RestController\n@RequestMapping(\"/" + mClass.getName().toLowerCase() + "s\")\n");
        cntrlImpl.setProperty("importList", "import org.springframework.web.bind.annotation.*;\n");
        return cntrl;
    }
}

