/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.model.MActivity;
import de.spraener.nxtgen.oom.model.MActivityControlFlow;
import de.spraener.nxtgen.oom.model.MActivityDecision;
import de.spraener.nxtgen.oom.model.MActivityNode;
import de.spraener.nxtgen.oom.model.MClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FSMHelper {
    private MClass fsmClass;
    private MActivity meActivity;
    private Map<String, ModelElement> id2Me = new HashMap<String, ModelElement>();

    public FSMHelper(MActivity meActivity) {
        this.meActivity = meActivity;
        this.setFSMClass((MClass)this.meActivity.getParent());
        this.fillIDMap((ModelElement)meActivity);
    }

    private void fillIDMap(ModelElement me) {
        if (me.getProperty("id") != null) {
            this.id2Me.put(me.getProperty("id"), me);
        }
        for (ModelElement child : me.getChilds()) {
            this.fillIDMap(child);
        }
    }

    public void setFSMClass(MClass fsmClass) {
        this.fsmClass = fsmClass;
    }

    public MClass getFSMClass() {
        return this.fsmClass;
    }

    public List<ModelElement> findChildsWithMetaType(ModelElement me, String metaType) {
        return me.getChilds().stream().filter(cf -> cf.getMetaType().equals(metaType)).collect(Collectors.toList());
    }

    public List<MActivityControlFlow> findControllFlows(ModelElement me, String idMatchingAttribute) {
        String meID = me.getProperty("id");
        ArrayList<MActivityControlFlow> flows = new ArrayList<MActivityControlFlow>();
        for (MActivityControlFlow controllFlow : this.listControlFlows(me)) {
            String targetID = controllFlow.getProperty(idMatchingAttribute);
            if (!targetID.equals(meID)) continue;
            flows.add(controllFlow);
        }
        return flows;
    }

    private List<MActivityControlFlow> listControlFlows(ModelElement me) {
        String meID = me.getProperty("id");
        return this.id2Me.values().stream().filter(c -> c instanceof MActivityControlFlow).map(c -> (MActivityControlFlow)c).filter(cf -> cf.getTargetID().equals(meID) || cf.getSourceID().equals(meID)).collect(Collectors.toList());
    }

    public List<MActivityControlFlow> findOutgoings(ModelElement me) {
        ArrayList<MActivityControlFlow> result = new ArrayList<MActivityControlFlow>();
        for (MActivityControlFlow cf : this.findControllFlows(me, "sourceID")) {
            ModelElement source = this.id2Me.get(cf.getTargetID());
            if (source instanceof MActivityDecision) {
                result.addAll(this.findControllFlows(source, "sourceID"));
                continue;
            }
            result.add(cf);
        }
        return result;
    }

    public List<MActivityControlFlow> findOIncoming(ModelElement me) {
        return this.findControllFlows(me, "targetID");
    }

    public String findInitNode(MActivity activity) {
        MActivityNode initNode = activity.getInitNode();
        return this.findOutgoings((ModelElement)initNode).get(0).getTarget();
    }

    public List<String> getFinalStates(MActivity activity) {
        return activity.getFinalNodes().stream().map(n -> n.getName()).collect(Collectors.toList());
    }

    public boolean isInteractive(ModelElement me) {
        return StereotypeHelper.hasStereotype((ModelElement)me, (String)RESTStereotypes.INTERACTIVE.getName());
    }
}

