/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToEntity;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Stereotype;
import de.spraener.nxtgen.model.impl.StereotypeImpl;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.model.MAttribute;
import de.spraener.nxtgen.oom.model.MClass;
import java.util.function.Consumer;

public class EntityToDDL
implements Transformation {
    public void doTransformation(ModelElement element) {
        if (!(element instanceof MClass)) {
            return;
        }
        if (!((MClass)element).hasStereotype(RESTStereotypes.ENTITY.getName())) {
            return;
        }
        ResourceToEntity.ensureEntityDefinition((MClass)element);
        this.create((MClass)element);
    }

    public MClass create(MClass mClass) {
        MClass ddl = mClass.getPackage().createMClass(mClass.getName() + "DDL");
        StereotypeImpl sType = new StereotypeImpl(RESTStereotypes.DDL.getName(), new Consumer[0]);
        ddl.addStereotypes((Stereotype)sType);
        sType.setTaggedValue("dbTable", ResourceToEntity.toTableName(mClass));
        for (MAttribute a : mClass.getAttributes()) {
            MAttribute dbAttr = a.cloneTo(ddl);
            dbAttr.addStereotypes(StereotypeHelper.getStereotype((ModelElement)a, (String)RESTStereotypes.DBFIELD.getName()));
        }
        return ddl;
    }
}

