/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.cartridge.rest.transformations.EntityToDDL;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToContoller;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToEntity;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToLogic;
import de.spraener.nxtgen.cartridge.rest.transformations.ResourceToTSType;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.oom.model.MClass;

public class DDLTransformation
implements Transformation {
    public void doTransformation(ModelElement modelElement) {
        if (!(modelElement instanceof MClass)) {
            return;
        }
        MClass mClass = (MClass)modelElement;
        if (mClass.hasStereotype(RESTStereotypes.RESSOURCE.getName())) {
            MClass entity = this.addEntity(mClass);
            this.addDDL(entity);
            MClass restController = this.addRESTController(mClass);
            MClass restLogic = this.addRESTLogic(mClass);
            MClass mClass2 = this.addTSType(mClass);
        }
        if (mClass.hasStereotype(RESTStereotypes.ENTITY.getName())) {
            ResourceToEntity.ensureEntityDefinition(mClass);
            this.addDDL(mClass);
        }
    }

    private MClass addRESTLogic(MClass mClass) {
        return new ResourceToLogic().create(mClass);
    }

    private MClass addEntity(MClass mClass) {
        return new ResourceToEntity().create(mClass);
    }

    private MClass addDDL(MClass entity) {
        System.err.println("Creating DDL for entity " + entity.getName());
        return new EntityToDDL().create(entity);
    }

    private MClass addRESTController(MClass mClass) {
        return new ResourceToContoller().create(mClass);
    }

    private MClass addTSType(MClass mClass) {
        return new ResourceToTSType().create(mClass);
    }
}

