/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest.transformations;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.cartridge.rest.transformations.FSMHelper;
import de.spraener.nxtgen.cartridge.rest.transformations.TransformationHelper;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Stereotype;
import de.spraener.nxtgen.model.impl.StereotypeImpl;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.cartridge.JavaHelper;
import de.spraener.nxtgen.oom.model.MActivity;
import de.spraener.nxtgen.oom.model.MActivityAction;
import de.spraener.nxtgen.oom.model.MClass;
import de.spraener.nxtgen.oom.model.MOperation;
import de.spraener.nxtgen.oom.model.MPackage;
import java.util.function.Consumer;

public class ControlledOperationToFSM
implements Transformation {
    public void doTransformation(ModelElement element) {
        if (!(element instanceof MClass)) {
            return;
        }
        MClass c = (MClass)element;
        if (c.getActivities() != null) {
            for (MActivity activity : c.getActivities()) {
                if (!StereotypeHelper.hasStereotype((ModelElement)activity, (String)RESTStereotypes.CONTROLLEDOPERATION.getName())) continue;
                this.createFinalStateMachine(activity);
            }
        }
    }

    private void createFinalStateMachine(MActivity activity) {
        FSMHelper fsmHelper = new FSMHelper(activity);
        MClass mClass = (MClass)activity.getParent();
        MPackage pkg = mClass.getPackage().findOrCreatePackage("logic");
        MClass fsmClass = pkg.createMClass(mClass.getName() + TransformationHelper.firstToUpperCaser(activity.getName()));
        fsmClass.putObject("fsmHelper", (Object)fsmHelper);
        fsmClass.putObject("originalClass", (Object)mClass);
        fsmClass.putObject("activity", (Object)activity);
        fsmClass.addStereotypes((Stereotype)new StereotypeImpl(RESTStereotypes.ACTIVITYIMPL.getName(), new Consumer[0]));
        fsmHelper.setFSMClass(fsmClass);
        StereotypeImpl sType = new StereotypeImpl(RESTStereotypes.CONTROLLEDOPERATION.getName(), new Consumer[0]);
        fsmClass.addStereotypes((Stereotype)sType);
        MOperation initOP = fsmClass.createOperation("initContext");
        initOP.createParameter("context", "FSMContext<" + mClass.getName() + ">");
        for (MActivityAction action : activity.getActions()) {
            this.addOperation(fsmHelper, action);
        }
    }

    private void addOperation(FSMHelper fsmHelper, MActivityAction action) {
        MClass fsmClass = fsmHelper.getFSMClass();
        MClass mClass = (MClass)action.getParent().getParent();
        if (fsmHelper.isInteractive((ModelElement)action)) {
            MOperation opBefore = fsmClass.createOperation(action.getName());
            opBefore.setType("Void");
            opBefore.createParameter("context", "FSMContext<" + mClass.getName() + ">");
            opBefore.putObject("activityAction", (Object)action);
            opBefore.setProperty("interruptedBefore", "true");
            for (Object st : action.getStereotypes()) {
                opBefore.getStereotypes().add(st);
            }
            MOperation opReturnFrom = fsmClass.createOperation("returnFrom" + JavaHelper.firstToUpperCase((String)action.getName()));
            opReturnFrom.setType("Object");
            opReturnFrom.createParameter("returnValue", "Object");
            opReturnFrom.createParameter("context", "FSMContext<" + mClass.getName() + ">");
            opReturnFrom.putObject("activityAction", (Object)action);
            opReturnFrom.setProperty("interruptedReturn", "true");
            for (Stereotype st : action.getStereotypes()) {
                opReturnFrom.getStereotypes().add(st);
            }
        } else {
            MOperation op = fsmClass.createOperation(action.getName());
            op.setType("Object");
            op.setName(action.getName());
            op.createParameter("context", "FSMContext<" + mClass.getName() + ">");
            op.putObject("activityAction", (Object)action);
            for (Stereotype st : action.getStereotypes()) {
                op.getStereotypes().add(st);
            }
        }
    }
}

