/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest;

import de.spraener.nxtgen.CodeGenerator;
import de.spraener.nxtgen.CodeGeneratorMapping;
import de.spraener.nxtgen.MustacheGenerator;
import de.spraener.nxtgen.NextGen;
import de.spraener.nxtgen.cartridge.rest.ActivityImplGenerator;
import de.spraener.nxtgen.cartridge.rest.PoJoGenerator;
import de.spraener.nxtgen.cartridge.rest.RESTCartridgeBase;
import de.spraener.nxtgen.cartridge.rest.RESTStereotypes;
import de.spraener.nxtgen.cartridge.rest.SpringBootApp;
import de.spraener.nxtgen.cartridge.rest.SpringBootAppGenerator;
import de.spraener.nxtgen.cartridge.rest.angular.TSTypeGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.ApiControllerBaseGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.ApiControllerGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.ControllerGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.LogicGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.PhpControllerBaseGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.PhpControllerGenerator;
import de.spraener.nxtgen.cartridge.rest.entity.DDLGenerator;
import de.spraener.nxtgen.cartridge.rest.entity.EntityGenerator;
import de.spraener.nxtgen.cartridge.rest.entity.PhpEntityGenerator;
import de.spraener.nxtgen.cartridge.rest.entity.PhpRepositoryGenerator;
import de.spraener.nxtgen.cartridge.rest.entity.RepositoryGenerator;
import de.spraener.nxtgen.cartridge.rest.filestrategies.PhpFileStrategy;
import de.spraener.nxtgen.filestrategies.ToFileStrategy;
import de.spraener.nxtgen.java.JavaCodeBlock;
import de.spraener.nxtgen.model.Model;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Stereotype;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.model.MPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class RESTCartridge
extends RESTCartridgeBase {
    @Override
    public String getName() {
        return "REST-Cartridge";
    }

    @Override
    public List<CodeGeneratorMapping> mapGenerators(Model model) {
        ArrayList<CodeGeneratorMapping> result = new ArrayList<CodeGeneratorMapping>();
        for (ModelElement me : model.getModelElements()) {
            NextGen.LOGGER.finer("handling model element " + me.getName());
            if (this.isEntity(me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new EntityGenerator(new Consumer[0])));
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new PhpEntityGenerator(cb -> cb.setToFileStrategy((ToFileStrategy)new PhpFileStrategy("Entity", me.getName() + ".php")))));
                continue;
            }
            if (this.isDDL(me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new DDLGenerator()));
                continue;
            }
            if (this.isTSType(me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new TSTypeGenerator(new Consumer[0])));
                continue;
            }
            if (this.isRepository(me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new RepositoryGenerator(new Consumer[0])));
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new PhpRepositoryGenerator(cb -> cb.setToFileStrategy((ToFileStrategy)new PhpFileStrategy("Repository", me.getName() + ".php")))));
                continue;
            }
            if (this.hasStereotype(RESTStereotypes.RESTCONTROLLER.getName(), me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new ControllerGenerator(new Consumer[0])));
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new PhpControllerBaseGenerator(cb -> cb.setToFileStrategy((ToFileStrategy)new PhpFileStrategy("Controller/Base", me.getName() + ".php")))));
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new PhpControllerGenerator(cb -> cb.setToFileStrategy((ToFileStrategy)new PhpFileStrategy("Controller", me.getName().replace("Base", "") + ".php")))));
                continue;
            }
            if (this.hasStereotype(RESTStereotypes.APIRESSOURCE.getName(), me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new ApiControllerGenerator(new Consumer[0])));
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new ApiControllerBaseGenerator(cb -> ((JavaCodeBlock)cb).setClassName(me.getName() + "Base"))));
                continue;
            }
            if (this.hasStereotype(RESTStereotypes.IMPL.getName(), me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new PoJoGenerator(new Consumer[0])));
                continue;
            }
            if (this.hasStereotype(RESTStereotypes.ACTIVITYIMPL.getName(), me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new ActivityImplGenerator()));
                continue;
            }
            if (this.isLogic(me)) {
                result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new LogicGenerator(new Consumer[0])));
                continue;
            }
            if (!this.isSprintBootApplication(me)) continue;
            NextGen.LOGGER.info(() -> "Creating SpringBoot-Application");
            result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new SpringBootAppGenerator(new Consumer[0])));
            result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new MustacheGenerator("mustache/springBootApp/build.gradle.mustache", "build.gradle", new BiConsumer[]{SpringBootApp::fillBuildScriptMap})));
            result.add(CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new MustacheGenerator("mustache/springBootApp/Dockerfile.mustache", "Dockerfile", new BiConsumer[]{SpringBootApp::fillDockerfileMap})));
        }
        return result;
    }

    protected CodeGeneratorMapping createMapping(ModelElement me, String stereotypeName, String aspect) {
        if (me instanceof MPackage && "CloudModule".equals(stereotypeName) && aspect.equals("docker-compose")) {
            return CodeGeneratorMapping.create((ModelElement)me, (CodeGenerator)new MustacheGenerator("/mustache/springBootApp/docker-compose-serviceblock.mustache", "docker-compose-service-block", new BiConsumer[]{SpringBootApp::dockerComposeServiceBlock}));
        }
        return super.createMapping(me, stereotypeName);
    }

    public String evaluate(Model m, ModelElement me, Stereotype sType, String aspect) {
        CodeGeneratorMapping mapping = this.createMapping(me, sType.getName(), aspect);
        if (mapping == null) {
            return "Unsupported evaluation request for ModelElement '" + me.getName() + " with aspect: '" + aspect + "'";
        }
        return mapping.getCodeGen().resolve(me, "").toCode();
    }

    private boolean isSprintBootApplication(ModelElement me) {
        return StereotypeHelper.hasStereotype((ModelElement)me, (String)RESTStereotypes.SPRINGBOOTAPP.getName());
    }

    private boolean isLogic(ModelElement me) {
        return StereotypeHelper.hasStereotype((ModelElement)me, (String)RESTStereotypes.LOGIC.getName());
    }

    private boolean isRepository(ModelElement me) {
        return this.hasStereotype(RESTStereotypes.REPOSITORY.getName(), me);
    }

    private boolean isEntity(ModelElement me) {
        return this.hasStereotype(RESTStereotypes.ENTITY.getName(), me);
    }

    private boolean isDDL(ModelElement me) {
        return this.hasStereotype(RESTStereotypes.DDL.getName(), me);
    }

    private boolean isTSType(ModelElement me) {
        return this.hasStereotype(RESTStereotypes.TSTYPE.getName(), me);
    }

    private boolean hasStereotype(String sTypeName, ModelElement me) {
        return StereotypeHelper.hasStereotype((ModelElement)me, (String)sTypeName);
    }
}

