/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridge.rest;

import de.spraener.nxtgen.CodeBlock;
import de.spraener.nxtgen.CodeGenerator;
import de.spraener.nxtgen.GroovyCodeBlockImpl;
import de.spraener.nxtgen.cartridge.rest.transformations.FSMHelper;
import de.spraener.nxtgen.java.JavaCodeBlock;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.impl.ModelElementImpl;
import de.spraener.nxtgen.oom.model.MActivity;
import de.spraener.nxtgen.oom.model.MActivityAction;
import de.spraener.nxtgen.oom.model.MClass;
import de.spraener.nxtgen.oom.model.MOperation;

public class ActivityImplGenerator
implements CodeGenerator {
    public CodeBlock resolve(ModelElement element, String templateName) {
        MClass fsmClass = (MClass)element;
        FSMHelper fsmHelper = (FSMHelper)fsmClass.getObject("fsmHelper");
        MClass mClass = (MClass)fsmClass.getObject("originalClass");
        Object importList = fsmClass.getProperty("importList");
        if (null == importList) {
            importList = "";
        }
        importList = (String)importList + "\nimport de.csp.fsm.FSMTransition;\nimport de.csp.fsm.FSMTransitions;\nimport de.csp.fsm.FSMRunnable;\nimport de.csp.fsm.FSMBefore;\nimport de.csp.fsm.FSMPrepareFor;\nimport de.csp.fsm.FSMReturnFrom;\nimport de.csp.fsm.FSMContext;\n\nimport " + mClass.getPackage().getFQName() + ".model.*;";
        fsmClass.setProperty("importList", (String)importList);
        this.setFSMClassAnnotation(fsmHelper, fsmClass);
        for (MOperation op : fsmClass.getOperations()) {
            if (op.getName().equals("initContext")) {
                this.addFSMBeforeAnnotation(op);
                continue;
            }
            this.addAnnotations(fsmHelper, op);
        }
        JavaCodeBlock jcb = new JavaCodeBlock("src/main/java", fsmClass.getPackage().getFQName(), fsmClass.getName());
        GroovyCodeBlockImpl gcb = new GroovyCodeBlockImpl("PoJoGenerator", (ModelElement)fsmClass, "/PoJoTemplate.groovy");
        jcb.addCodeBlock((CodeBlock)gcb);
        return jcb;
    }

    private void setFSMClassAnnotation(FSMHelper fsmHelper, MClass fsmClass) {
        MActivity activity = (MActivity)fsmClass.getObject("activity");
        StringBuilder annotations = new StringBuilder();
        annotations.append("@FSMRunnable(\n");
        annotations.append("    initialMethod = \"").append(fsmHelper.findInitNode(activity)).append("\",\n");
        annotations.append("    finalStates = {");
        boolean firstState = true;
        for (String state : fsmHelper.getFinalStates(activity)) {
            if (!firstState) {
                annotations.append(",");
            } else {
                firstState = false;
            }
            annotations.append("\n");
            annotations.append("        \"").append(state).append("\"");
        }
        annotations.append("\n    }\n");
        annotations.append(")\n");
        Object fsmAnnos = fsmClass.getProperty("annotations");
        if (fsmAnnos == null) {
            fsmAnnos = "";
        }
        fsmAnnos = (String)fsmAnnos + "\n" + annotations.toString();
        fsmClass.setProperty("annotations", (String)fsmAnnos);
    }

    private void addFSMBeforeAnnotation(MOperation initOP) {
        Object annitations = initOP.getProperty("annotations");
        if (annitations == null) {
            annitations = "";
        }
        annitations = (String)annitations + "@FSMBefore\n    ";
        initOP.setProperty("annotations", (String)annitations);
    }

    private void addAnnotations(FSMHelper fsmHelper, MOperation op) {
        MActivityAction action = (MActivityAction)op.getObject("activityAction");
        StringBuffer annotations = new StringBuffer();
        Object annotationsStr = "";
        if (op.getProperty("interruptedBefore") == null) {
            for (ModelElement modelElement : fsmHelper.findOutgoings((ModelElement)action)) {
                String targetName = modelElement.getProperty("target");
                String guard = modelElement.getProperty("transitOn");
                if (guard == null) {
                    guard = modelElement.getProperty("guard");
                }
                if (guard == null) {
                    guard = "VOID";
                }
                ModelElementImpl transition = new ModelElementImpl();
                transition.setParent((ModelElement)op);
                transition.setMetaType("mTransition");
                op.getChilds().add(transition);
                annotations.append("\n        @FSMTransition(target=\"" + targetName + "\", guard=\"" + guard + "\"),");
                if (annotations.length() <= 0) continue;
                annotationsStr = "@FSMTransitions(transistions={" + annotations.toString() + "\n    })\n    ";
            }
        } else if (op.getProperty("interruptedBefore") != null) {
            annotationsStr = "@FSMPrepareFor(\"" + action.getName() + "\")\n    ";
        }
        if (op.getProperty("interruptedReturn") != null) {
            annotationsStr = "@FSMReturnFrom(\"" + action.getName() + "\")\n    " + (String)annotationsStr;
        }
        op.setProperty("annotations", (String)annotationsStr);
    }
}

