/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package de.spraener.nxtgen.cartridge.rest;

import de.spraener.nxtgen.CodeGeneratorMapping;
import de.spraener.nxtgen.MustacheGenerator;
import de.spraener.nxtgen.NextGen;
import de.spraener.nxtgen.cartridge.rest.angular.TSTypeGenerator;
import de.spraener.nxtgen.cartridge.rest.cntrl.*;
import de.spraener.nxtgen.cartridge.rest.entity.*;
import de.spraener.nxtgen.cartridge.rest.filestrategies.PhpFileStrategy;
import de.spraener.nxtgen.java.JavaCodeBlock;
import de.spraener.nxtgen.model.Model;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Stereotype;
import de.spraener.nxtgen.oom.StereotypeHelper;
import de.spraener.nxtgen.oom.model.MPackage;

import java.util.ArrayList;
import java.util.List;

public class RESTCartridge extends  RESTCartridgeBase {
    @Override
    public String getName() {
        return "REST-Cartridge";
    }

    @Override
    public List<CodeGeneratorMapping> mapGenerators(Model model) {
        List<CodeGeneratorMapping> result = new ArrayList<>();
        for( ModelElement me : model.getModelElements() ) {
            NextGen.LOGGER.finer("handling model element "+me.getName());
            if( isEntity(me) ) {
                result.add(CodeGeneratorMapping.create(me, new EntityGenerator()));
                result.add(CodeGeneratorMapping.create(me, new PhpEntityGenerator(
                        cb -> cb.setToFileStrategy(new PhpFileStrategy("Entity", me.getName()+".php"))
                )));
            } else if( isDDL(me) ) {
                result.add(CodeGeneratorMapping.create(me, new DDLGenerator()));
            } else if( isTSType(me) ) {
                result.add(CodeGeneratorMapping.create(me, new TSTypeGenerator()));
            } else if( isRepository(me) ) {
                result.add(CodeGeneratorMapping.create(me, new RepositoryGenerator()));
                result.add(CodeGeneratorMapping.create(me, new PhpRepositoryGenerator(
                        cb -> cb.setToFileStrategy(new PhpFileStrategy("Repository", me.getName()+".php"))
                )));
            } else if( hasStereotype(RESTStereotypes.RESTCONTROLLER.getName(), me) ) {
                result.add(CodeGeneratorMapping.create(me, new ControllerGenerator()));
                result.add(CodeGeneratorMapping.create(me, new PhpControllerBaseGenerator(
                        cb -> cb.setToFileStrategy(new PhpFileStrategy("Controller/Base", me.getName()+".php"))
                )));
                result.add(CodeGeneratorMapping.create(me, new PhpControllerGenerator(
                        cb -> cb.setToFileStrategy(new PhpFileStrategy("Controller", me.getName().replace("Base", "")+".php"))
                )));
            } else if( hasStereotype(RESTStereotypes.APIRESSOURCE.getName(), me) ) {
                result.add(CodeGeneratorMapping.create(me, new ApiControllerGenerator()));
                result.add(CodeGeneratorMapping.create(me, new ApiControllerBaseGenerator(
                        cb -> ((JavaCodeBlock)cb).setClassName(me.getName()+"Base")
                )));
            } else if( hasStereotype(RESTStereotypes.IMPL.getName(), me) ) {
                result.add(CodeGeneratorMapping.create(me, new PoJoGenerator()));
            } else if( hasStereotype(RESTStereotypes.ACTIVITYIMPL.getName(), me) ) {
                result.add(CodeGeneratorMapping.create(me, new ActivityImplGenerator()));
            } else if( isLogic(me) ) {
                result.add(CodeGeneratorMapping.create(me, new LogicGenerator()));
            } else if( isSprintBootApplication(me) ) {
                NextGen.LOGGER.info(()->"Creating SpringBoot-Application");
                result.add(CodeGeneratorMapping.create(me, new SpringBootAppGenerator()));
                result.add(CodeGeneratorMapping.create(me, new MustacheGenerator(
                        "mustache/springBootApp/build.gradle.mustache",
                        "build.gradle",
                        SpringBootApp::fillBuildScriptMap
                )));
                result.add(CodeGeneratorMapping.create(me, new MustacheGenerator(
                        "mustache/springBootApp/Dockerfile.mustache",
                        "Dockerfile",
                        SpringBootApp::fillDockerfileMap
                )));
            }
        }
        return result;
    }

    protected CodeGeneratorMapping createMapping(ModelElement me, String stereotypeName, String aspect) {
        if( me instanceof MPackage && "CloudModule".equals(stereotypeName) && aspect.equals("docker-compose")) {
            return CodeGeneratorMapping.create(me,
                    new MustacheGenerator(
                            "/mustache/springBootApp/docker-compose-serviceblock.mustache",
                            "docker-compose-service-block",
                            SpringBootApp::dockerComposeServiceBlock
                    )
            );
        }
        return super.createMapping(me, stereotypeName);
    }

    @Override
    public String evaluate(Model m, ModelElement me, Stereotype sType, String aspect) {
        CodeGeneratorMapping mapping = this.createMapping(me, sType.getName(), aspect);
        if( mapping == null ) {
            return "Unsupported evaluation request for ModelElement '" + me.getName() + " with aspect: '" + aspect + "'";
        }
        return mapping.getCodeGen().resolve(me, "").toCode();
    }

    private boolean isSprintBootApplication(ModelElement me) {
        return StereotypeHelper.hasStereotype(me, RESTStereotypes.SPRINGBOOTAPP.getName());
    }

    private boolean isLogic(ModelElement me) {
        return StereotypeHelper.hasStereotype(me, RESTStereotypes.LOGIC.getName());
    }

    private boolean isRepository(ModelElement me) {
        return hasStereotype(RESTStereotypes.REPOSITORY.getName(), me);
    }

    private boolean isEntity(ModelElement me) {
        return hasStereotype(RESTStereotypes.ENTITY.getName(), me);
    }

    private boolean isDDL(ModelElement me) {
        return hasStereotype(RESTStereotypes.DDL.getName(), me);
    }

    private boolean isTSType(ModelElement me) {
        return hasStereotype(RESTStereotypes.TSTYPE.getName(), me);
    }

    private boolean hasStereotype(String sTypeName, ModelElement me) {
        return StereotypeHelper.hasStereotype(me, sTypeName);
    }

}
