/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.target;

import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.target.CodeBlockSnippet;
import de.spraener.nxtgen.target.CodeSection;
import de.spraener.nxtgen.target.CodeSnippet;
import de.spraener.nxtgen.target.CodeTargetContext;

public class CodeSnippetRef {
    private CodeSection owningSection;
    private CodeSnippet snippet;

    public CodeSnippetRef(CodeSection owningSection, CodeSnippet snippet) {
        this.owningSection = owningSection;
        this.snippet = snippet;
    }

    public CodeSnippetRef insertBefore(CodeSnippet snippetToInsert) {
        this.owningSection.insertBefore(this.snippet, snippetToInsert);
        return this;
    }

    public CodeSnippetRef insertBefore(Object aspect, ModelElement attr, String code) {
        return this.insertBefore(new CodeBlockSnippet(aspect, attr, code));
    }

    public CodeSnippetRef insertBefore(Object aspect, String code) {
        return this.insertBefore(new CodeBlockSnippet(aspect, CodeTargetContext.getActiveContext().getModelElement(), code));
    }

    public CodeSnippetRef insertBefore(String code) {
        this.insertBefore(CodeTargetContext.getActiveContext().getAspect(), code);
        return this;
    }

    public CodeSnippetRef replace(CodeSnippet snippetToInsert) {
        this.owningSection.replace(this.snippet, snippetToInsert);
        this.snippet = snippetToInsert;
        return this;
    }

    public CodeSnippetRef replace(Object aspect, ModelElement attr, String code) {
        return this.replace(new CodeBlockSnippet(aspect, attr, code));
    }

    public CodeSnippetRef replace(Object aspect, String code) {
        return this.replace(new CodeBlockSnippet(aspect, CodeTargetContext.getActiveContext().getModelElement(), code));
    }

    public CodeSnippetRef replace(String code) {
        this.replace(CodeTargetContext.getActiveContext().getAspect(), code);
        return this;
    }

    public CodeSnippetRef insertAfter(CodeSnippet snippetToInsert) {
        this.owningSection.insertAfter(this.snippet, snippetToInsert);
        return this;
    }

    public CodeSnippetRef insertAfter(Object aspect, ModelElement attr, String code) {
        this.insertAfter(new CodeBlockSnippet(aspect, attr, code));
        return this;
    }

    public CodeSnippetRef insertAfter(Object aspect, String code) {
        this.insertAfter(new CodeBlockSnippet(aspect, null, code));
        return this;
    }

    public CodeSnippetRef insertAfter(String code) {
        this.insertAfter(CodeTargetContext.getActiveContext().getAspect(), code);
        return this;
    }

    public CodeSnippet get() {
        return this.snippet;
    }
}

