/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.model;

import de.spraener.nxtgen.model.Model;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Relation;
import de.spraener.nxtgen.model.Stereotype;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractModelElement
implements ModelElement {
    private List<ModelElement> childs = new ArrayList<ModelElement>();
    private String name = "UNKNOWN";
    private ModelElement parent;
    private List<Stereotype> stereotypes = null;
    private List<Relation> relations = new ArrayList<Relation>();
    private Map<String, String> properties = new HashMap<String, String>();
    private Model model = null;

    public AbstractModelElement() {
    }

    public AbstractModelElement(ModelElement me) {
        this.setName(me.getName());
        this.childs = me.getChilds();
        this.properties = me.getProperties();
        this.stereotypes = me.getStereotypes();
        this.parent = me.getParent();
    }

    @Override
    public List<ModelElement> getChilds() {
        return this.childs;
    }

    public ModelElement addModelElement(ModelElement child) {
        this.childs.add(child);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public ModelElement setName(String name) {
        this.name = name;
        return this;
    }

    public Stream<ModelElement> filterChilds(Function<ModelElement, Boolean> filter) {
        return this.childs.stream().filter(me -> (Boolean)filter.apply((ModelElement)me));
    }

    @Override
    public ModelElement getParent() {
        return this.parent;
    }

    public void setParent(ModelElement parent) {
        this.parent = parent;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public List<Stereotype> getStereotypes() {
        return this.stereotypes;
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model model) {
        this.model = model;
    }
}

