/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.invocation;

import de.spraener.nxtgen.ModelLoader;
import de.spraener.nxtgen.NextGen;
import de.spraener.nxtgen.model.Model;
import java.io.File;
import java.util.UUID;

public class NextGenInvocation
implements Runnable,
ModelLoader {
    private String workDir;
    private Model model;
    private String cartridgeName = null;
    private ModelLoader modelLoader;
    private String modelURI;

    private NextGenInvocation() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void run() {
        if (this.workDir != null) {
            new File(this.workDir).mkdirs();
            NextGen.setWorkingDir(this.workDir);
        }
        if (this.cartridgeName != null) {
            NextGen.runCartridgeWithName(this.cartridgeName);
        }
        ModelLoader activeModelLoader = null;
        if (this.model != null) {
            activeModelLoader = this;
        } else if (this.modelLoader != null) {
            activeModelLoader = this.modelLoader;
        }
        if (activeModelLoader != null) {
            NextGen.addModelLoader(activeModelLoader);
            NextGen.setActiveLoader(activeModelLoader);
        }
        NextGen.main(new String[]{this.modelURI});
    }

    @Override
    public boolean canHandle(String modelURI) {
        return modelURI.equals(this.modelURI);
    }

    @Override
    public Model loadModel(String modelURI) {
        return this.model;
    }

    public static final class Builder {
        private NextGenInvocation invocation = new NextGenInvocation();

        public Builder withWorkdir(String workdir) {
            this.invocation.workDir = workdir;
            return this;
        }

        public Builder withModel(Model model) {
            this.invocation.model = model;
            this.invocation.modelURI = UUID.randomUUID().toString();
            return this;
        }

        public Builder withCartridge(String name) {
            this.invocation.cartridgeName = name;
            return this;
        }

        public Builder withModelLoader(ModelLoader loader) {
            this.invocation.modelLoader = loader;
            return this;
        }

        public Builder withModelURI(String modelURI) {
            this.invocation.modelURI = modelURI;
            return this;
        }

        public NextGenInvocation build() {
            return this.invocation;
        }
    }
}

