/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.incubator;

import de.spraener.nxtgen.NextGen;
import de.spraener.nxtgen.incubator.BlueprintSupplier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class BlueprintResourceLister
implements BlueprintSupplier {
    private static final Logger LOGGER = Logger.getLogger(BlueprintResourceLister.class.getName());
    private String rsrcPath;
    private List<String> fileList = null;

    public BlueprintResourceLister(String rsrcPath) {
        this.rsrcPath = rsrcPath;
    }

    public List<String> listFiles() {
        if (this.fileList == null) {
            this.fileList = new ArrayList<String>();
            try {
                this.getResourceFiles(this.fileList, this.rsrcPath, "");
            }
            catch (IOException xc) {
                LOGGER.severe(() -> "Error while listing blueprint files under " + this.rsrcPath + ": " + xc.getMessage());
            }
        }
        return this.fileList;
    }

    private List<String> getResourceFiles(List<String> filenames, String root, String path) throws IOException {
        if (this.getClass().getResourceAsStream(root + "/_bpFileList") != null) {
            this.readBpFileList(this.getClass().getResourceAsStream(root + "/_bpFileList"), filenames);
            return filenames;
        }
        try (InputStream in = this.getResourceAsStream(root + path);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource;
            while ((resource = br.readLine()) != null) {
                InputStream subStream = this.getClass().getResourceAsStream(root + path + "/" + resource + "/.");
                if (subStream != null) {
                    this.getResourceFiles(filenames, root, path + "/" + resource);
                    continue;
                }
                Object name = path + "/" + resource;
                if (((String)name).startsWith("/")) {
                    name = ((String)name).substring(1);
                }
                filenames.add((String)name);
            }
        }
        return filenames;
    }

    private List<String> readBpFileList(InputStream is, List<String> filenames) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
                filenames.add(line.trim());
            }
        }
        return filenames;
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resource);
        return in == null ? this.getClass().getResourceAsStream(resource) : in;
    }

    @Override
    public String getContent(String resourceName) {
        String string;
        block8: {
            InputStreamReader isr = this.getInputStream(resourceName);
            try {
                string = IOUtils.toString((Reader)isr);
                if (isr == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception xc) {
                    NextGen.LOGGER.severe("Could not get content of resource: " + resourceName);
                    throw new RuntimeException(xc);
                }
            }
            isr.close();
        }
        return string;
    }

    @Override
    public InputStreamReader getInputStream(String resource) {
        InputStream is = this.getClass().getResourceAsStream(this.rsrcPath + "/" + resource);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is);
    }
}

