/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridges;

import de.spraener.nxtgen.Cartridge;
import de.spraener.nxtgen.CodeGeneratorMapping;
import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.annotations.CGV19Blueprint;
import de.spraener.nxtgen.annotations.CGV19Cartridge;
import de.spraener.nxtgen.annotations.CGV19Component;
import de.spraener.nxtgen.annotations.CGV19Generator;
import de.spraener.nxtgen.annotations.CGV19MustacheGenerator;
import de.spraener.nxtgen.annotations.CGV19Transformation;
import de.spraener.nxtgen.cartridges.GeneratorWrapper;
import de.spraener.nxtgen.cartridges.MustacheGeneratorWrapper;
import de.spraener.nxtgen.cartridges.TransformationWrapper;
import de.spraener.nxtgen.incubator.BlueprintGeneratorWrapper;
import de.spraener.nxtgen.model.Model;
import de.spraener.nxtgen.model.ModelElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class AnnotatedCartridgeImpl
implements Cartridge {
    private static final Logger LOGGER = Logger.getLogger(AnnotatedCartridgeImpl.class.getName());
    private String name;
    private List<Transformation> transformationList = new ArrayList<Transformation>();
    private List<GeneratorWrapper> generatorWrapperList = new ArrayList<GeneratorWrapper>();

    public AnnotatedCartridgeImpl() {
        this.init(this.getClass());
    }

    public AnnotatedCartridgeImpl(Class<?> cartridgeClass) {
        this.init(cartridgeClass);
    }

    private void init(Class<?> clazz) {
        String pkgName = clazz.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackage(pkgName, new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage(pkgName)));
        Set componentClasses = reflections.getTypesAnnotatedWith(CGV19Component.class);
        for (Object componentClass : componentClasses) {
            for (Method m : ((Class)componentClass).getMethods()) {
                if (m.isAnnotationPresent(CGV19Generator.class)) {
                    this.generatorWrapperList.add(new GeneratorWrapper((Class<?>)componentClass, m));
                }
                if (m.isAnnotationPresent(CGV19MustacheGenerator.class)) {
                    this.generatorWrapperList.add(new MustacheGeneratorWrapper((Class<?>)componentClass, m));
                }
                if (m.isAnnotationPresent(CGV19Blueprint.class)) {
                    this.generatorWrapperList.add(new BlueprintGeneratorWrapper((Class<?>)componentClass, m));
                }
                if (!m.isAnnotationPresent(CGV19Transformation.class)) continue;
                this.transformationList.add(new TransformationWrapper((Class<?>)componentClass, m));
            }
        }
        Set transformationClasses = reflections.getTypesAnnotatedWith(CGV19Transformation.class, false);
        for (Class t : transformationClasses) {
            if (Modifier.isAbstract(t.getModifiers()) || !t.isAnnotationPresent(CGV19Transformation.class)) continue;
            this.transformationList.add(new TransformationWrapper(t));
        }
        Set generatorClasses = reflections.getTypesAnnotatedWith(CGV19Generator.class, false);
        for (Class g : generatorClasses) {
            if (Modifier.isAbstract(g.getModifiers()) || !g.isAnnotationPresent(CGV19Generator.class)) continue;
            this.generatorWrapperList.add(new GeneratorWrapper(g));
        }
        this.name = clazz.isAnnotationPresent(CGV19Cartridge.class) ? clazz.getAnnotation(CGV19Cartridge.class).value() : "UNDEFINED";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Transformation> getTransformations() {
        return this.transformationList;
    }

    @Override
    public List<CodeGeneratorMapping> mapGenerators(Model m) {
        ArrayList<CodeGeneratorMapping> mappingList = new ArrayList<CodeGeneratorMapping>();
        for (ModelElement e : m.getModelElements()) {
            for (GeneratorWrapper gw : this.generatorWrapperList) {
                if (!gw.matches(e)) continue;
                CodeGeneratorMapping mapping = CodeGeneratorMapping.create(e, gw);
                mapping.setStereotype(gw.requiredStereotype());
                mappingList.add(mapping);
            }
        }
        return mappingList;
    }

    public List<GeneratorWrapper> getGeneratorWrappers() {
        return this.generatorWrapperList;
    }
}

